% --------------------------------------------------------------
% Compute charge distribution for 2D electrostatics by MoM
% --------------------------------------------------------------
function [charge, sigma] = MoM2D(xs, ys, xe, ye, V)

% Arguments:
%    xs     = x-coordinate for starting points
%    ys     = y-coordinate for starting points
%    xe     = x-coordinate for ending points
%    ye     = y-coordinate for ending points
%    V      = the potential
% Returns:
%    sigma  = charge density for each element
%    charge = total charge on each element

xobs = 0.5*(xs + xe);               % Observation points
yobs = 0.5*(ys + ye);
h = sqrt((xe-xs).^2 + (ye-ys).^2);  % Length of elements

% Loop over elements
for k = 1:length(xs)                         
  s = (  (xobs-xs(k))*(xe(k)-xs(k)) ...
       + (yobs-ys(k))*(ye(k)-ys(k)))/h(k)^2;
  d = sqrt(  (xobs-xs(k)).^2 ...
           + (yobs-ys(k)).^2 ...
           - s.^2*h(k)^2 + 1e-24);
  xis = -s*h(k);
  xie = (1-s)*h(k);
  temp =  0.5*xie.*log(xie.^2+d.^2) ...
            - xie + d.*atan(xie./d) ...
        -(0.5*xis.*log(xis.^2+d.^2) ...
            - xis + d.*atan(xis./d));
  A(:,k) = - temp(:)/(2*pi*8.854187);
end

sigma = (A\V')';                    % Charge density
charge = h.*sigma;                  % Charge per element
